// public/js/dateUtils.js
function convertDateClientSide(date, gmtOffset = null) {
  const { DateTime } = luxon;

 
  // Ensure ISO format with UTC if not already ending in Z
  let isoDate = date.includes("T") ? date : date.replace(" ", "T");
  if (!isoDate.endsWith("Z")) isoDate += "Z";

  // Parse the date as UTC
  let dt = DateTime.fromISO(isoDate, { zone: "utc" });

  let converted;
  if (gmtOffset !== null && gmtOffset !== "") {
    // If a GMT offset is provided, use it
    const offsetMinutes = parseFloat(gmtOffset) * 60;
    converted = dt.plus({ minutes: offsetMinutes });
  } else {
    // Otherwise, use browser timezone
    const browserTimeZone = Intl.DateTimeFormat().resolvedOptions().timeZone;
    converted = dt.setZone(browserTimeZone);
  }

  return {
    original_utc: dt.toISO(),
    converted_time: converted.toFormat("dd-MM-yyyy hh:mm a"),
    used_zone: gmtOffset ? `GMT${gmtOffset}` : converted.zoneName
  };
}

function renderConvertedDates() {
  document.querySelectorAll(".convert-date").forEach(el => {
    const date = el.dataset.date;
    const offset = el.dataset.offset || null;

    if (date) {
      const result = convertDateClientSide(date, offset);
      el.textContent = result.converted_time;
    }
  });
}

// Auto-run on page load
document.addEventListener("DOMContentLoaded", renderConvertedDates);
