  $(document).ready(function() {
    
    // Select/Deselect all checkboxes
    $("#selectAll").on("click", function() {
      $(".select-driver").prop("checked", this.checked);
    });

    // Delete selected drivers with SweetAlert2
    $("#deleteSelected").on("click", function() {
      const selectedDrivers = $(".select-driver:checked").map(function() {
        return $(this).val();
      }).get();

      if (selectedDrivers.length === 0) {
        Swal.fire({
          icon: 'warning',
          title: 'No passengers selected',
          text: 'Please select at least one passenger to delete.',
          toast: true,
          position: 'top-end',
          showConfirmButton: false,
          timer: 3000
        });
        return;
      }

      Swal.fire({
        title: 'Are you sure?',
        text: "Selected passengers will be permanently deleted.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#3085d6',
        confirmButtonText: 'Yes, delete'
      }).then((result) => {
        if (result.isConfirmed) {
          $.ajax({
            url: "/admin/delete-user",
            type: "POST",
            contentType: "application/json",
            data: JSON.stringify({
              user_id: selectedDrivers
            }),
            success: function(response) {
              Swal.fire({
                icon: 'success',
                title: response.message || 'Deleted successfully!',
                toast: true,
                position: 'top-end',
                showConfirmButton: false,
                timer: 3000
              });
              pagination.loadData(pagination.currentPage);
              $("#selectAll").prop("checked", false);
            },
            error: function(error) {
             

              Swal.fire({
                icon: 'error',
                title: response,
                toast: true,
                position: 'top-end',
                showConfirmButton: false,
                timer: 3000
              });
            }
          });
        }
      });
    });

    pagination.loadData(1);
  });
