$(document).on("click", ".change-astatus, .change-ostatus, .change-status", async function () {
  const button = $(this);
  const driverId = button.data("id");
  const currentValue = button.data("value"); // 0 or 1
  const api_key = button.data("api_key");

  const actionType =
    button.data("type") ||
    (button.hasClass("change-astatus") ? "verify" :
     button.hasClass("change-ostatus") ? "availability" : "status");

    const confirmResult = await Swal.fire({
     title: 'Confirm Change',
     text: `Are you sure you want to change this driver's ${actionType}?`,
     icon: 'question',
     showCancelButton: true,
     confirmButtonText: 'Yes, change it',
     cancelButtonText: 'Cancel'
   });

  if (!confirmResult.isConfirmed) return;

  const formData = new FormData();
  formData.append("driver_id", driverId);
  formData.append("api_key", api_key);

  // console.log(currentValue, actionType);
   
  // Toggle logic: flip 1 to 0 or 0 to 1
  const toggledValue = currentValue === 1 || currentValue === "1" ? "0" : "1";

  if (actionType === "verify") {
    formData.append("d_is_verified", toggledValue);
  } else if (actionType === "availability") {
    formData.append("d_is_available", toggledValue);
  } else {
    // fallback or additional logic if needed
    formData.append("d_active", toggledValue); // optional
  }

  try {
    const response = await fetch("/api/v1/driverapi/updatedriverprofile", {
      method: "POST",
      body: formData
    });

    const result = await response.json();


    if (result.resDecrypt.code  == 200) {
            Swal.fire({
      icon: 'success',
      title: 'Status changed successfully!',
      toast: "true",
      position: 'top-end',
      showConfirmButton: false,
      timer: 3000,
      timerProgressBar: true
    });

      pagination.loadData(pagination.currentPage);
    }
  } catch (error) {
    Swal.fire({
      icon: 'error',
      title: 'An error occurred',
      text: error.message,
      toast: true,
      position: 'top-end',
      showConfirmButton: false,
      timer: 3000,
      timerProgressBar: true
    });
  }
});


     //delete drivers bulk or single driver


$("#selectAll").on("click", function () {
  $(".select-driver").prop("checked", this.checked);
});

// Delete or Restore selected drivers
$(document).on("click", "#deleteSelected", function () {
  const action = $(this).data("action"); // 'delete' or 'restore'
  const selectedDrivers = $(".select-driver:checked")
    .map(function () {
      return $(this).val();
    })
    .get();

  if (selectedDrivers.length === 0) {
    Swal.fire({
      icon: "warning",
      title: "No drivers selected",
      text: "Please select at least one driver",
      toast: true,
      position: "top-end",
      showConfirmButton: false,
      timer: 3000,
      timerProgressBar: true,
    });
    return;
  }

  const isDelete = action !== "restore";
  const url = "/admin/delete-drivers"
 
  Swal.fire({
    title: isDelete ? "Delete Drivers?" : "Restore Drivers?",
    text: isDelete
      ? "Selected drivers will be permanently deleted."
      : "Selected drivers will be restored.",
    icon: "warning",
    showCancelButton: true,
    confirmButtonColor: isDelete ? "#d33" : "#28a745",
    cancelButtonColor: "#6c757d",
    confirmButtonText: isDelete ? "Yes, delete them!" : "Yes, restore them!",
  }).then((result) => {
    if (result.isConfirmed) {
      $.ajax({
        url: url,
        type: "POST",
        contentType: "application/json",
        data: JSON.stringify({ driver_id: selectedDrivers }),
        success: function (response) {
          Swal.fire({
            icon: "success",
            title:
              response.message ||
              (isDelete
                ? "Drivers deleted successfully!"
                : "Drivers restored successfully!"),
            toast: true,
            position: "top-end",
            showConfirmButton: false,
            timer: 3000,
            timerProgressBar: true,
          });
          pagination.loadData(pagination.currentPage);
          $("#selectAll").prop("checked", false);
        },
        error: function (xhr) {
          Swal.fire({
            icon: "error",
            title: isDelete
              ? "Error deleting drivers"
              : "Error restoring drivers",
            text: xhr.responseJSON?.message || "An error occurred",
            toast: true,
            position: "top-end",
            showConfirmButton: false,
            timer: 3000,
            timerProgressBar: true,
          });
        },
      });
    }
  });
});

