
function exportTableToCSV(tableSelector, filename = 'data.csv', allData = false, dataArray = []) {
  let csv = [];

  if (allData && dataArray.length) {
    const headers = Object.keys(dataArray[0]);
    csv.push(headers.join(','));

    dataArray.forEach(row => {
      let values = headers.map(key => {
        let value = row[key];
        return typeof value === 'string' ? `"${value.replace(/"/g, '""')}"` : value;
      });
      csv.push(values.join(','));
    });

  } else {
    const rows = document.querySelectorAll(`${tableSelector} tr`);
    for (let row of rows) {
      let cols = row.querySelectorAll('td, th');
      let rowData = Array.from(cols).map(col => `"${col.innerText.trim().replace(/"/g, '""')}"`);
      csv.push(rowData.join(','));
    }
  }

  const blob = new Blob([csv.join('\n')], { type: 'text/csv' });
  const link = document.createElement('a');
  link.href = URL.createObjectURL(blob);
  link.download = filename;
  link.click();
}

function exportTableToPrint(tableSelector, title = 'Data Report') {
  const printWindow = window.open('', '', 'width=1000,height=700');
  const tableHtml = document.querySelector(tableSelector).outerHTML;

  printWindow.document.write(`
    <html>
      <head>
        <title>${title}</title>
        <link rel="stylesheet" href="/path/to/bootstrap.min.css">
      </head>
      <body>
        <h3 style="text-align:center; margin-top: 20px;">${title}</h3>
        <div class="table-responsive">${tableHtml}</div>
      </body>
    </html>
  `);

  printWindow.document.close();
  printWindow.focus();
  printWindow.print();
  printWindow.close();
}
