document.addEventListener("click", async function (e) {
  if (e.target.classList.contains("change-status")) {
    const btn = e.target;
    const user_id = btn.dataset.id;
    const api_key = btn.dataset.key;

    // Get all data from button

    const userData = btn.dataset;

    let active = userData.active == "true" ? 0 : 1;

    const payload = {
      user_id,
      api_key,
      is_return_details: 1, // to return updated user details
      active, // toggle status
    };

    try {
      const response = await fetch(
        `/api/v1/userapi/updateuserprofile?api_key=${api_key}`,
        {
          method: "POST",
          headers: {
            "Content-Type": "application/json",
          },
          body: JSON.stringify(payload),
        }
      );

      const result = await response.json();

      if (result.resDecrypt?.code === 200) {
        Swal.fire({
          icon: "success",
          title: `User ${
            payload.active === 1 ? "activated" : "deactivated"
          } successfully`,
          toast: true,
          position: "top-end",
          showConfirmButton: false,
          timer: 3000,
          timerProgressBar: true,
        });
        pagination.loadData(1);
        // Optional: Refresh the list or update button
        pagination.refresh?.();
      } else {
        Swal.fire({
          icon: "error",
          title: "Update failed",
          text: result.message || "Something went wrong.",
          toast: true,
          position: "top-end",
          showConfirmButton: false,
          timer: 3000,
          timerProgressBar: true,
        });
      }
    } catch (error) {
      Swal.fire({
        icon: "error",
        title: "Request error",
        text: error.message,
      });
    }
  }
});

// Utility to get selected passenger/driver IDs
function getSelectedIds() {
  return $(".select-driver:checked")
    .map(function () {
      return $(this).val();
    })
    .get();
}

// Show toast alert
function showToast(icon, title) {
  Swal.fire({
    icon,
    title,
    toast: true,
    position: "top-end",
    showConfirmButton: false,
    timer: 3000,
    timerProgressBar: true,
  });
}

// Handle bulk action (restore/delete)
// function handleBulkAction(type) {
//   const selectedIds = getSelectedIds();
//   if (selectedIds.length === 0) {
//     showToast("warning", `No passengers selected. Please select at least one to ${type}.`);
//     return;
//   }

//   const actionConfig = {
//     restore: {
//       title: "Restore Passengers?",
//       text: "Selected passengers will be restored.",
//       icon: "question",
//       confirmText: "Yes, restore",
//       confirmColor: "#28a745",
//       url: "/admin/delete-user", // Update if different
//       successMsg: "Restored successfully!",
//       errorMsg: "Error restoring passengers.",
//     },
//     delete: {
//       title: "Are you sure?",
//       text: "Selected passengers will be permanently deleted.",
//       icon: "warning",
//       confirmText: "Yes, delete",
//       confirmColor: "#d33",
//       url: "/admin/delete-user",
//       successMsg: "Deleted successfully!",
//       errorMsg: "Error delet344334ing passengers.",
//     },
//   }[type];

//   Swal.fire({
//     title: actionConfig.title,
//     text: actionConfig.text,
//     icon: actionConfig.icon,
//     showCancelButton: true,
//     confirmButtonText: actionConfig.confirmText,
//     cancelButtonText: "Cancel",
//     confirmButtonColor: actionConfig.confirmColor,
//     cancelButtonColor: "#6c757d",
//   }).then((result) => {
//     if (result.isConfirmed) {
//       $.ajax({
//         url: actionConfig.url,
//         type: "POST",
//         contentType: "application/json",
//         data: JSON.stringify({ user_id: selectedIds }),
//         success: function (response) {

//           showToast("success", response.message || actionConfig.successMsg);
//           pagination.loadData(pagination.currentPage);
//           $("#selectAll").prop("checked", false);
//         },
//         error: function (error) {
//                     console.log(error)
//           showToast("error", actionConfig.errorMsg);
//         },
//       });
//     }
//   });
// }
function handleBulkAction(type) {
  const selectedIds = getSelectedIds();
  if (selectedIds.length === 0) {
    showToast(
      "warning",
      `No passengers selected. Please select at least one to ${type}.`
    );
    return;
  }

  const config = {
    restore: {
      title: "Restore Passengers?",
      text: "Selected passengers will be restored.",
      icon: "question",
      confirmText: "Yes, restore",
      confirmColor: "#28a745",
      url: "/admin/delete-user", // endpoint must handle restore logic via `action`
      successMsg: "Passengers restored successfully!",
      errorMsg: "Failed to restore passengers.",
      data: { user_id: selectedIds, action: "restore" },
    },
    delete: {
      title: "Are you sure?",
      text: "Selected passengers will be permanently deleted.",
      icon: "warning",
      confirmText: "Yes, delete",
      confirmColor: "#d33",
      url: "/admin/delete-user",
      successMsg: "Passengers deleted successfully!",
      errorMsg: "Failed to 3434delete passengers.",
      data: { user_id: selectedIds, action: "delete" },
    },
  }[type];

  if (!config) {
    showToast("error", "Invalid bulk action.");
    return;
  }

  Swal.fire({
    title: config.title,
    text: config.text,
    icon: config.icon,
    showCancelButton: true,
    confirmButtonText: config.confirmText,
    cancelButtonText: "Cancel",
    confirmButtonColor: config.confirmColor,
    cancelButtonColor: "#6c757d",
  }).then((result) => {
    if (result.isConfirmed) {
      $.ajax({
        url: config.url,
        type: "POST",
        contentType: "application/json",
        data: JSON.stringify(config.data),
        success: function (response) {
          showToast("success", response.message || config.successMsg);
          pagination.loadData(pagination.currentPage);
          $("#selectAll").prop("checked", false);
        },
        error: function (xhr) {
          console.error("Error response:", xhr);
          let message = config.errorMsg;
          if (xhr.responseJSON?.message) {
            message = xhr.responseJSON.message;
          }
          showToast("error", message);
        },
      });
    }
  });
}

// Restore selected passengers
$("#restoreSelected").on("click", () => handleBulkAction("restore"));

// Delete selected passengers
$("#deleteSelected").on("click", () => handleBulkAction("delete"));

// Select/Deselect all checkboxes
$("#selectAll").on("click", function () {
  $(".select-driver").prop("checked", this.checked);
});
